<?php
require_once '../includes/db.php';
session_start();
if(!isset($_SESSION['admin_logged']) || $_SESSION['admin_logged']!==true) header('Location: login.php');
if(isset($_GET['action']) && isset($_GET['id'])){
    $id = intval($_GET['id']);
    $act = $_GET['action'];
    if($act==='approve'){
        $stmt = $mysqli->prepare('UPDATE deposits SET status="approved" WHERE id=?'); $stmt->bind_param('i',$id); $stmt->execute();
        $row = $mysqli->query('SELECT user_id,amount FROM deposits WHERE id='.$id)->fetch_assoc();
        $stmt = $mysqli->prepare('UPDATE users SET balance = balance + ? WHERE id=?'); $stmt->bind_param('di',$row['amount'],$row['user_id']); $stmt->execute();
    } elseif($act==='reject'){
        $stmt = $mysqli->prepare('UPDATE deposits SET status="rejected" WHERE id=?'); $stmt->bind_param('i',$id); $stmt->execute();
    }
    header('Location: deposits.php'); exit;
}
$res = $mysqli->query('SELECT d.*,u.email FROM deposits d JOIN users u ON d.user_id=u.id ORDER BY d.created_at DESC');
?>
<!doctype html><html><head><meta charset="utf-8"><title>Deposits</title><link rel="stylesheet" href="../assets/style.css"></head><body>
<div class="container"><div class="card"><h2>Deposits</h2>
<table style="width:100%"><tr><th>User</th><th>Method</th><th>Amount</th><th>TX</th><th>Status</th><th>Action</th></tr>
<?php while($r = $res->fetch_assoc()): ?>
<tr><td><?php echo htmlspecialchars($r['email']);?></td><td><?php echo $r['method'];?></td><td><?php echo number_format($r['amount'],2);?></td><td><?php echo htmlspecialchars($r['transaction_id']);?></td><td><?php echo $r['status'];?></td>
<td><?php if($r['status']=='pending'): ?><a href="?action=approve&id=<?php echo $r['id']?>">Approve</a> | <a href="?action=reject&id=<?php echo $r['id']?>">Reject</a><?php else: echo '-'; endif;?></td></tr>
<?php endwhile; ?>
</table></div></div></body></html>
