<?php
require_once '../includes/db.php';
session_start();
if(!isset($_SESSION['admin_logged']) || $_SESSION['admin_logged']!==true) header('Location: login.php');
$q = $_GET['q'] ?? '';
$sql = "SELECT * FROM users";
if($q) $sql .= " WHERE name LIKE '%".$mysqli->real_escape_string($q)."%' OR email LIKE '%".$mysqli->real_escape_string($q)."%'";
$res = $mysqli->query($sql);
?>
<!doctype html><html><head><meta charset="utf-8"><title>Users</title><link rel="stylesheet" href="../assets/style.css"></head><body>
<div class="container">
  <div class="card">
    <h2>Users</h2>
    <form method="get"><input class="input" name="q" placeholder="Search by name or email"/></form><br/>
    <table style="width:100%;border-collapse:collapse">
      <tr style="text-align:left"><th>Name</th><th>Email</th><th>Balance</th><th>UID</th><th>Slots</th></tr>
      <?php while($u = $res->fetch_assoc()): 
         $stmt = $mysqli->prepare('SELECT GROUP_CONCAT(slot_number) as s FROM user_slots WHERE user_id=?');
         $stmt->bind_param('i',$u['id']); $stmt->execute(); $slots = $stmt->get_result()->fetch_assoc()['s'];
      ?>
      <tr><td><?php echo htmlspecialchars($u['name']);?></td><td><?php echo htmlspecialchars($u['email']);?></td><td><?php echo number_format($u['balance'],2);?></td><td><?php echo htmlspecialchars($u['uid']);?></td><td><?php echo $slots?:'-';?></td></tr>
      <?php endwhile; ?>
    </table>
  </div>
</div>
</body></html>
