<?php
require_once 'includes/db.php';
require_once 'includes/auth.php';
require_login();
$uid = $_SESSION['user_id'];
$stmt = $mysqli->prepare('SELECT * FROM users WHERE id=? LIMIT 1');
$stmt->bind_param('i',$uid);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

$site = (isset($_SERVER['HTTP_HOST'])? $_SERVER['HTTP_HOST'] : 'localhost');
$referral_link = 'https://'.$site.'/?ref='.$user['referral_code'];

$stmt = $mysqli->prepare('SELECT COUNT(*) as total FROM referrals WHERE referrer_id=?');
$stmt->bind_param('i',$uid); $stmt->execute(); $total_ref = $stmt->get_result()->fetch_assoc()['total'];

$stmt = $mysqli->prepare('SELECT COUNT(DISTINCT referee_id) as active_ref FROM referrals r JOIN user_slots s ON r.referee_id=s.user_id WHERE r.referrer_id=?');
$stmt->bind_param('i',$uid); $stmt->execute(); $active_ref = $stmt->get_result()->fetch_assoc()['active_ref'];

$total_income = number_format($user['balance'],2);
$slot_count_stmt = $mysqli->prepare('SELECT COUNT(*) as cnt FROM user_slots WHERE user_id=?');
$slot_count_stmt->bind_param('i',$uid); $slot_count_stmt->execute(); $slot_count = $slot_count_stmt->get_result()->fetch_assoc()['cnt'];
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Dashboard</title><link rel="stylesheet" href="assets/style.css"></head>
<body>
<div class="container">
  <div class="layout">
    <div class="sidebar card">
      <div class="center"><img src="<?php echo $user['profile_pic']?:'https://via.placeholder.com/80';?>" class="profile-pic" alt="pic"><h3><?php echo htmlspecialchars($user['name']);?></h3>
      <div class="small">UID: <?php echo htmlspecialchars($user['uid']);?></div>
      <div class="small">Referral: <?php echo htmlspecialchars($user['referral_code']);?></div></div>
      <hr/>
      <a class="menu-item" href="dashboard.php">Dashboard</a>
      <a class="menu-item" href="slot.php">Slot</a>
      <a class="menu-item" href="wallet.php">Wallet</a>
      <a class="menu-item" href="logout.php">Logout</a>
    </div>
    <div style="flex:1">
      <div class="card header">
        <div>
          <form method="get"><input class="input" name="q" placeholder="Search..."></form>
        </div>
        <div>
          <div class="small">Referral link:</div>
          <div style="word-break:break-all;color:#9bd7e0"><?php echo htmlspecialchars($referral_link);?></div>
        </div>
      </div>

      <div class="card stats">
        <div class="stat center"><div class="small">Total referrals</div><h2><?php echo $total_ref;?></h2></div>
        <div class="stat center"><div class="small">Active referrals</div><h2><?php echo $active_ref;?></h2></div>
        <div class="stat center"><div class="small">Total income</div><h2><?php echo $total_income;?></h2></div>
        <div class="stat center"><div class="small">Slots updated</div><h2><?php echo $slot_count;?></h2></div>
      </div>

      <div class="card" style="margin-top:12px">
        <h3>Slot Overview</h3>
        <p class="small">Go to <a href="slot.php">Slot</a> to update slots and view capacity boxes.</p>
      </div>

    </div>
  </div>
</div>
</body>
</html>
