<?php
require_once 'includes/db.php';
session_start();
if(isset($_SESSION['user_id'])) header('Location: dashboard.php');

$err = '';
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $email = $_POST['email'] ?? '';
    $pass = $_POST['password'] ?? '';
    if($email && $pass){
        $stmt = $mysqli->prepare('SELECT id,password,is_active FROM users WHERE email=? LIMIT 1');
        $stmt->bind_param('s',$email);
        $stmt->execute();
        $res = $stmt->get_result();
        if($row = $res->fetch_assoc()){
            if(password_verify($pass, $row['password'])){
                $_SESSION['user_id'] = $row['id'];
                header('Location: dashboard.php');
                exit;
            } else $err='Invalid credentials';
        } else $err='Invalid credentials';
    } else $err='Enter email and password';
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Login</title><link rel="stylesheet" href="assets/style.css"></head>
<body>
<div class="container">
  <div class="card">
    <h2>Login</h2>
    <?php if($err): ?><div class="small" style="color:#ffb4b4;"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>
    <form method="post">
      <input class="input" name="email" placeholder="Email" /><br/><br/>
      <input class="input" name="password" placeholder="Password" type="password" /><br/><br/>
      <button class="btn" type="submit">Login</button>
      <a href="register.php" style="margin-left:12px;color:#9bd7e0">Register</a>
    </form>
  </div>
</div>
</body>
</html>
