<?php
require_once 'includes/db.php';
session_start();
$err='';
$referral_from_url = '';
if (isset($_GET['ref'])) {
    $referral_from_url = trim($_GET['ref']);
}
if($_SERVER['REQUEST_METHOD']==='POST'){
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm'] ?? '';
    $used_ref = trim($_POST['referral_code'] ?? '');

    if(!$name || !$email || !$password || !$confirm) $err='Please fill all fields';
    elseif($password !== $confirm) $err='Passwords do not match';
    else {
        // check referral code exists
        $stmt = $mysqli->prepare('SELECT id,referral_code FROM users WHERE referral_code=? LIMIT 1');
        $stmt->bind_param('s', $used_ref);
        $stmt->execute();
        $res = $stmt->get_result();
        if(!$res->fetch_assoc()){
            $err='Invalid referral code. Registration requires a valid referral code.';
        } else {
            // create user
            $refcode = strtoupper(substr($name,0,3)).rand(100,999);
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $mysqli->prepare('INSERT INTO users (name,email,password,referral_code,used_referral_code,uid) VALUES (?,?,?,?,?,?)');
            $uid = 'U'.time().rand(10,99);
            $stmt->bind_param('ssssss',$name,$email,$hash,$refcode,$used_ref,$uid);
            if($stmt->execute()){
                $newid = $mysqli->insert_id;
                // record referral link
                $stmt2 = $mysqli->prepare('SELECT id FROM users WHERE referral_code=? LIMIT 1');
                $stmt2->bind_param('s',$used_ref);
                $stmt2->execute();
                $r = $stmt2->get_result()->fetch_assoc();
                if($r){
                    $stmt3 = $mysqli->prepare('INSERT INTO referrals (referrer_id,referee_id) VALUES (?,?)');
                    $stmt3->bind_param('ii',$r['id'],$newid);
                    $stmt3->execute();
                }
                $_SESSION['user_id'] = $newid;
                header('Location: dashboard.php');
                exit;
            } else $err='Registration failed (duplicate email?)';
        }
    }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Register</title><link rel="stylesheet" href="assets/style.css"></head>
<body>
<div class="container">
  <div class="card">
    <h2>Register (Referral Required)</h2>
    <?php if($err): ?><div class="small" style="color:#ffb4b4;"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>
    <form method="post">
      <input class="input" name="name" placeholder="Full name" /><br/><br/>
      <input class="input" name="email" placeholder="Email" /><br/><br/>
      <input class="input" name="password" placeholder="Password" type="password" /><br/><br/>
      <input class="input" name="confirm" placeholder="Confirm Password" type="password" /><br/><br/>
      <input class="input" name="referral_code" placeholder="Referral Code (required)" value="<?php echo htmlspecialchars($referral_from_url); ?>" /><br/><br/>
      <button class="btn" type="submit">Register</button>
    </form>
  </div>
</div>
</body>
</html>
