<?php
require_once 'includes/db.php';
require_once 'includes/auth.php';
require_login();
$uid = $_SESSION['user_id'];

$slots = [];
$res = $mysqli->query('SELECT * FROM slot_settings ORDER BY slot_number');
while($r = $res->fetch_assoc()) $slots[$r['slot_number']] = $r;

$uslots = [];
$stmt = $mysqli->prepare('SELECT slot_number FROM user_slots WHERE user_id=?');
$stmt->bind_param('i',$uid); $stmt->execute();
$res2 = $stmt->get_result();
while($r = $res2->fetch_assoc()) $uslots[] = $r['slot_number'];

$err=''; $msg='';
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['slot'])){
    $slot_to = intval($_POST['slot']);
    if($slot_to>1 && !in_array($slot_to-1,$uslots)) $err='You must activate previous slot first.';
    elseif(in_array($slot_to,$uslots)) $err='Slot already activated.';
    else {
        $price = $slots[$slot_to]['price'];
        $stmt = $mysqli->prepare('SELECT u2.id as refid FROM users u JOIN referrals r ON r.referee_id=u.id JOIN users u2 ON r.referrer_id=u2.id WHERE u.id=? LIMIT 1');
        $stmt->bind_param('i',$uid); $stmt->execute();
        $r = $stmt->get_result()->fetch_assoc();
        $refid = $r['refid'] ?? null;

        $stmt = $mysqli->prepare('INSERT INTO user_slots (user_id,slot_number) VALUES (?,?)');
        $stmt->bind_param('ii',$uid,$slot_to);
        if($stmt->execute()){
            if($refid){
                $credit = ($price * 0.6);
                $stmt2 = $mysqli->prepare('UPDATE users SET balance = balance + ? WHERE id=?');
                $stmt2->bind_param('di',$credit,$refid);
                $stmt2->execute();

                $fund = ($price * 0.4);
                $stmt3 = $mysqli->prepare('INSERT INTO salary_fund (amount,source) VALUES (?,?)');
                $src = 'Slot '.$slot_to.' purchase by user '.$uid;
                $stmt3->bind_param('ds',$fund,$src);
                $stmt3->execute();
            }
            $msg='Slot activated successfully.';
            header('Location: slot.php');
            exit;
        } else $err='Failed to activate slot.';
    }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Slots</title><link rel="stylesheet" href="assets/style.css"></head>
<body>
<div class="container">
  <div class="layout">
    <div class="sidebar card">
      <h3>Menu</h3>
      <a class="menu-item" href="dashboard.php">Dashboard</a>
      <a class="menu-item" href="slot.php">Slot</a>
      <a class="menu-item" href="wallet.php">Wallet</a>
      <a class="menu-item" href="logout.php">Logout</a>
    </div>
    <div style="flex:1">
      <div class="card">
        <h2>Slots</h2>
        <?php if($err): ?><div class="small" style="color:#ffb4b4;"><?php echo htmlspecialchars($err);?></div><?php endif; ?>
        <?php if($msg): ?><div class="small" style="color:#b7ffb7;"><?php echo htmlspecialchars($msg);?></div><?php endif; ?>
        <?php foreach($slots as $num=>$s): ?>
          <div style="margin-top:12px;padding:12px;background:#071427;border-radius:8px">
            <div class="small">Slot <?php echo $num;?> — Price: <?php echo number_format($s['price'],2);?> — Capacity: <?php echo $s['capacity'];?></div>
            <div style="margin-top:8px">
              <?php if(in_array($num,$uslots)): ?>
                <div class="small" style="color:#a7f3d0">Activated</div>
              <?php else: ?>
                <form method="post" style="display:inline-block"><input type="hidden" name="slot" value="<?php echo $num;?>"><button class="btn">Activate Slot <?php echo $num;?></button></form>
              <?php endif; ?>
            </div>
            <?php if($num==1): 
               $stmt = $mysqli->prepare('SELECT COUNT(*) as cnt FROM referrals r JOIN user_slots s ON r.referee_id=s.user_id WHERE r.referrer_id=? AND s.slot_number=1');
               $stmt->bind_param('i',$uid); $stmt->execute(); $filled = $stmt->get_result()->fetch_assoc()['cnt'];
               $cap = $s['capacity'];
            ?>
              <div style="margin-top:8px">
                <?php for($i=1;$i<=$cap;$i++): ?>
                  <span style="display:inline-block;width:18px;height:18px;margin-right:6px;border-radius:4px;background:<?php echo ($i <= $filled)? '#16a34a' : '#334155';?>"></span>
                <?php endfor; ?>
              </div>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>
</body>
</html>
