<?php
require_once 'includes/db.php';
require_once 'includes/auth.php';
require_login();
$uid = $_SESSION['user_id'];
$msg=''; $err='';

$stmt = $mysqli->prepare('SELECT balance FROM users WHERE id=?');
$stmt->bind_param('i',$uid); $stmt->execute(); $balance = $stmt->get_result()->fetch_assoc()['balance'];

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['deposit'])){
    $method = $_POST['method'] ?? '';
    $amount = floatval($_POST['amount'] ?? 0);
    $tx = $_POST['transaction_id'] ?? '';
    $stmt = $mysqli->prepare('SELECT min_deposit,bkash_number,nagad_number FROM settings LIMIT 1');
    $stmt->execute(); $s = $stmt->get_result()->fetch_assoc();
    if($amount < $s['min_deposit']) $err='Amount below minimum deposit.';
    else {
        $stmt = $mysqli->prepare('INSERT INTO deposits (user_id,method,amount,transaction_id) VALUES (?,?,?,?)');
        $stmt->bind_param('isds',$uid,$method,$amount,$tx);
        if($stmt->execute()) $msg='Deposit request sent.';
        else $err='Failed to create deposit request.';
    }
}

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['withdraw'])){
    $method = $_POST['wmethod'] ?? '';
    $amount = floatval($_POST['wamount'] ?? 0);
    $account = $_POST['waccount'] ?? '';
    $stmt = $mysqli->prepare('SELECT min_withdraw FROM settings LIMIT 1');
    $stmt->execute(); $s = $stmt->get_result()->fetch_assoc();
    if($amount < $s['min_withdraw']) $err='Amount below minimum withdraw.';
    else {
        $stmt = $mysqli->prepare('INSERT INTO withdraws (user_id,method,amount,account) VALUES (?,?,?,?)');
        $stmt->bind_param('isds',$uid,$method,$amount,$account);
        if($stmt->execute()) $msg='Withdraw request sent.';
        else $err='Failed to create withdraw request.';
    }
}

?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Wallet</title><link rel="stylesheet" href="assets/style.css"></head>
<body>
<div class="container">
  <div class="layout">
    <div class="sidebar card">
      <a class="menu-item" href="dashboard.php">Dashboard</a>
      <a class="menu-item" href="slot.php">Slot</a>
      <a class="menu-item" href="wallet.php">Wallet</a>
      <a class="menu-item" href="logout.php">Logout</a>
    </div>
    <div style="flex:1">
      <div class="card">
        <h2>Wallet</h2>
        <?php if($err): ?><div class="small" style="color:#ffb4b4;"><?php echo htmlspecialchars($err);?></div><?php endif; ?>
        <?php if($msg): ?><div class="small" style="color:#b7ffb7;"><?php echo htmlspecialchars($msg);?></div><?php endif; ?>
        <div class="small">Current balance: <?php echo number_format($balance,2);?></div>
        <hr/>
        <h3>Deposit</h3>
        <form method="post">
          <label class="small">Method</label><br/>
          <select name="method" class="input"><option>bKash</option><option>Nagad</option></select><br/><br/>
          <input class="input" name="amount" placeholder="Amount"/><br/><br/>
          <input class="input" name="transaction_id" placeholder="Transaction ID"/><br/><br/>
          <button class="btn" name="deposit">Send Deposit Request</button>
        </form>
        <hr/>
        <h3>Withdraw</h3>
        <form method="post">
          <label class="small">Method</label><br/>
          <select name="wmethod" class="input"><option>bKash</option><option>Nagad</option></select><br/><br/>
          <input class="input" name="wamount" placeholder="Amount"/><br/><br/>
          <input class="input" name="waccount" placeholder="bKash/Nagad Number"/><br/><br/>
          <button class="btn" name="withdraw">Send Withdraw Request</button>
        </form>
      </div>
    </div>
  </div>
</div>
</body>
</html>
